<?php
require_once plugin_dir_path( __FILE__ ) . 'includes/class-uwac_template.php';
require_once plugin_dir_path( __FILE__ ) . 'includes/class-uwac_floatingwidget.php';
require_once plugin_dir_path( __FILE__ ) . 'includes/class-uwac_useraccount.php';

class Uwac_Common {
	
	/**
	* The ID of this plugin.
	*
	* @since    1.0.0
	* @access   private
	* @var      string    $plugin_name    The ID of this plugin.
	*/
	private $plugin_name;
	
	/**
	* The version of this plugin.
	*
	* @since    1.0.0
	* @access   private
	* @var      string    $version    The current version of this plugin.
	*/
	private $version;
	
	/**
	* Initialize the class and set its properties.
	*
	* @since    1.0.0
	* @param      string    $plugin_name       The name of the plugin.
	* @param      string    $version    The version of this plugin.
	*/
	public function __construct( $plugin_name, $version ) {
		$this->plugin_name = $plugin_name;
		$this->version = $version;
	}


	/**
	 * Floating Widget View
	 * 
	 * @since 1.0.0
	 */
	static function floating_widget_view(){
		$themes_obj 	= Uwac::get_themes();
		$active_themes 	= Uwac::get_themes()->get_themes();
		$general 		= cs_uwac_get_settings('general_settings');
		$widgets 		= cs_uwac_get_settings('floating_widgets');
		$accounts 		= cs_uwac_get_settings('user_accounts');

		if (!empty($widgets)){
			foreach ($widgets as $widget){
				$_widget = new uwac_floatingwidget($widget);
				$settings = $_widget->get_settings();
				
				$is_visible = $_widget->is_visible();
				
				if (!$is_visible){
					continue;
				}
				
				$widget_settings_output = array();
	
				// WhatsApp SVG Icon
				$wazap_icon = self::get_wazap_icon();
				
				/**
				 * Widget User Accounts
				 */
				$widget_accounts_type 	= $settings['accounts']['type'];
				$enabled_accounts = array();
				$accounts_list = '';
				if (!empty($accounts)){
					foreach($accounts as $account){
						$_account = new uwac_useraccount($account);
						$_account_settings = $_account->get_settings();
						
						// Account Temporarily Disabled
						if ($_account_settings['is_disabled']){ continue; }
		
						$hide_on_widgets = $_account_settings['hide_on_widgets'];
						if (!$hide_on_widgets){
		
							$account_id 	= $_account_settings['id'];
							$always_online 	= $_account_settings['always_online'];
							$is_now_active	= $_account_settings['status'];
							
							$add_account_to_list 	= false;
							$account_position 		= false;
							if ($widget_accounts_type == 'all'){
								$add_account_to_list = true;
							} else if ($widget_accounts_type == 'online'){
								if ($always_online){
									$add_account_to_list = true;
								} else {
									if ($is_now_active === 'online'){
										$add_account_to_list = true;
									}
								}
							} else if ($widget_accounts_type == 'selected'){
								$selected_accounts = $settings['accounts']['enabled'];
								$account_position = array_search($account_id, $selected_accounts);
							
								if ($account_position !== false){
									$add_account_to_list = true;
								}
							} else if ($widget_accounts_type == 'selected_online'){
								$selected_accounts = $settings['accounts']['enabled'];
								$account_position = array_search($account_id, $selected_accounts);
							
								if ($account_position !== false){
									if ($always_online){
										$add_account_to_list = true;
									} else {
										if ($is_now_active === 'online'){
											$add_account_to_list = true;
										}
									}
								}
							}

							// Add Current Account to Enabled Accounts list
							if ($add_account_to_list){
								if ($account_position !== false){
									$enabled_accounts[$account_position] = $_account_settings;
								} else {
									$enabled_accounts[] = $_account_settings;
								}
							}
						} 
					}
		
					// Sort to preserve backend order
					if ($widget_accounts_type == 'selected' || $widget_accounts_type == 'selected_online'){
						ksort($enabled_accounts);
					}
				}
				
				foreach($enabled_accounts as $account){
					$item_tpl = new uwac_template(plugin_dir_path( __FILE__ ) . 'views/floating-widget-item-view.tpl');
					$item_tpl->set('account_avatar',$account['avatar']);
					$item_tpl->set('account_avatar_type',$account['avatar_type']);
					$item_tpl->set('account_id',$account['id']);
					$item_tpl->set('account_name',$account['name']);
					$item_tpl->set('account_label',$account['label']);
					$item_tpl->set('account_placeholder',$account['placeholder']);
					$item_tpl->set('account_status',$account['status']);
					$item_tpl->set('account_status_text',$account['status_text']);
					$item_tpl->set('account_status_display',$account['status_display']);
					$item_tpl->set('url',$account['url']);
					$item_tpl->set('wazap_icon',$account['wazap_icon']);
					$accounts_list .= $item_tpl->render(false);
				}


				/**
				 * Floating Widget Template
				 */
	
				// Widget Theme
				$theme_name 		= (isset($settings['theme']['theme'])) ? $settings['theme']['theme'] : false;
				$theme_settings 	= (isset($settings['theme']['settings'])) ? $settings['theme']['settings'] : false;
				if ($theme_name && $theme_settings){
					// $theme_settings = $themes_obj->parse_theme_settings($theme_name,$theme_settings);
					$active_theme = $active_themes['widget'][$theme_name];
					$theme_settings = $active_theme->instance->parse_settings($theme_settings);
				}
				
				// Widget Button Label
				$force_label_hide 	= ($settings['button']['label_visibility'] == true) ? true : false;
				
				
				// Widget Classes
				// ----------------------------------------------------------
				$widget_classes = array();
				$widget_classes[] = ($theme_name) ? "cs-uwac__popup-theme--{$theme_name}" : "cs-uwac__popup-notheme";
				if ($force_label_hide){
					$widget_classes[] = 'cs-uwac__popup--hide-label';
				}
				$widget_position = (isset($settings['theme']['settings']["uwac_theme-{$theme_name}__position"])) ? $settings['theme']['settings']["uwac_theme-{$theme_name}__position"] : 'bottomright';
				$widget_classes[] = "cs-uwac__position--{$widget_position}";
	
				if (isset($settings['id'])){
					$widget_classes[] = "cs-uwac__popup-id--".$settings['id'];
				}
	
	
				// Widget Inline Styles
				// ----------------------------------------------------------
				$widget_inline_style = '';
				if (!$settings['button']['icon']) {
					$widget_inline_style .= '--uwac-btn-icon-display: flex;';
				} else {
					$widget_inline_style .= '--uwac-btn-icon-display: none;';
				}
				if ($theme_settings){
					$widget_inline_style .= $theme_settings;
				}
				$widget_inline_style = $themes_obj->clean_css_code($widget_inline_style);
	
	
				// Widget Settings
				// ----------------------------------------------------------
				// Call To Action
				$_cta 	= $settings['calltoaction'];
				$widget_settings_output['cta'] = $_cta;

				// GDPR
				$_gdpr 	= ($settings['gdpr']['status'] === false) ? false : true;
				$widget_settings_output['gdpr'] = $_gdpr;

				// Output
				$widget_settings_output = json_encode($widget_settings_output);
	
	
				// Render Widget Template
				// ----------------------------------------------------------
				$tpl = new uwac_template(plugin_dir_path( __FILE__ ) . 'views/floating-widget-view.tpl');
				$tpl->set('widget_classes',implode(" ",$widget_classes));
				$tpl->set('widget_inline_style',$widget_inline_style);
				$tpl->set('widget_settings',$widget_settings_output);
				$tpl->set('button_label',$settings['button']['label']);
				$tpl->set('button_icon',$settings['button']['icon']);
				$tpl->set('popup_title', $settings['popup']['title']);
				$tpl->set('popup_description', $settings['popup']['description']);
				$tpl->set('response_time', $settings['popup']['response_time']);
				if ($settings['gdpr']['status']){
					$tpl->set('gdpr_notice',$tpl->getFile(plugin_dir_path( __FILE__ ) . 'views/floating-widget-gdpr-notice-view.tpl'));
					$tpl->set('gdpr_notice_text',$settings['gdpr']['text']);
				} else {
					$tpl->set('gdpr_notice',false);
				}
				$tpl->set('accounts_list',$accounts_list);
				$tpl->set('wazap_icon',$wazap_icon);
				
				// Render the template
				$tpl->render();
			}
		}
	}

	private static function get_wazap_icon(){
		$_svg 	= CS_UWAC_PLUGIN_PATH . '/common/img/whatsapp-logo-outline-black.svg';
		$_svg2 	= file_get_contents($_svg);
		$output = "<span>{$_svg2}</span>";

		return $output;
	}

	/**
	 * Helper Functions
	 */
	static function in_post_category($categories = array(),$post){	
		$product_cat = self::parse_post_categories($categories);
		return has_term($product_cat,'category');
	}
	static function parse_post_categories($categories){
		$output = array();
		foreach ($categories as $cat_id){
			// $term = get_term_by('id', $cat_id, 'category', 'ARRAY_A'); // Get as array
			$term = get_term_by('id', $cat_id, 'category');
			$output[] = $term->slug;
		}
		return $output;
	}

	static function in_product_category($categories = array(),$post){
		$product_cat = self::parse_product_categories($categories);
		return has_term($product_cat,'product_cat');
	}
	static function parse_product_categories($categories){
		$output = array();
		foreach ($categories as $cat_id){
			// $term = get_term_by('id', $cat_id, 'product_cat', 'ARRAY_A'); // Get as array
			$term = get_term_by('id', $cat_id, 'product_cat');
			$output[] = $term->slug;
		}
		return $output;
	}


	private static function sanitize($string){
		return filter_var($string, FILTER_SANITIZE_STRING, FILTER_FLAG_STRIP_LOW);
	}
}